/*
 * This file is part of AdBlock  <https://getadblock.com/>,
 * Copyright (C) 2013-present  Adblock, Inc.
 *
 * AdBlock is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * AdBlock is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with AdBlock.  If not, see <http://www.gnu.org/licenses/>.
 */

// Record the last element to be right-clicked, since that information isn't
// passed to the contextmenu click handler that calls top_open_blacklist_ui

// eslint-disable-next-line @typescript-eslint/no-unused-vars
let rightClickedItem = null;

if (document.body) {
  document.body.addEventListener('contextmenu', (e) => {
    rightClickedItem = e.srcElement;
  });
  document.body.addEventListener('click', () => {
    /* eslint-disable-next-line @typescript-eslint/no-unused-vars */
    rightClickedItem = null;
  });
}
